/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.common;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class OrderedHashtable
extends Dictionary
implements Serializable {
    Vector keys;
    Vector values;

    public OrderedHashtable(int n, float f) {
        this.keys = new Vector(n, (int)(f * (float)n));
        this.values = new Vector(n, (int)(f * (float)n));
    }

    public OrderedHashtable(int n) {
        this.keys = new Vector(n);
        this.values = new Vector(n);
    }

    public OrderedHashtable() {
        this.keys = new Vector();
        this.values = new Vector();
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    public synchronized Enumeration keys() {
        return new KeyEnumeration();
    }

    public synchronized Enumeration elements() {
        return new ValueEnumeration();
    }

    public synchronized boolean contains(Object object) {
        return this.values.indexOf(object) >= 0;
    }

    public synchronized boolean containsKey(Object object) {
        return this.keys.indexOf(object) >= 0;
    }

    public synchronized Object get(Object object) {
        int n = this.keys.indexOf(object);
        if (n >= 0) {
            return this.values.elementAt(n);
        }
        return null;
    }

    protected void rehash() {
    }

    public synchronized Object put(Object object, Object object2) {
        int n = this.keys.indexOf(object);
        if (n >= 0) {
            this.keys.setElementAt(object, n);
            this.values.setElementAt(object2, n);
            return null;
        }
        this.keys.addElement(object);
        this.values.addElement(object2);
        return null;
    }

    public synchronized Object remove(Object object) {
        Object var2_2 = null;
        int n = this.keys.indexOf(object);
        if (n >= 0) {
            var2_2 = this.values.elementAt(n);
            this.keys.removeElementAt(n);
            this.values.removeElementAt(n);
        }
        return var2_2;
    }

    public synchronized void clear() {
        this.keys.removeAllElements();
        this.values.removeAllElements();
    }

    public synchronized Object clone() {
        return new Object();
    }

    public synchronized String toString() {
        return new String("");
    }

    private class KeyEnumeration
    implements Enumeration {
        int currentIndex;

        public boolean hasMoreElements() {
            return this.currentIndex < OrderedHashtable.this.keys.size();
        }

        public Object nextElement() {
            if (this.currentIndex < OrderedHashtable.this.keys.size()) {
                return OrderedHashtable.this.keys.elementAt(this.currentIndex++);
            }
            return null;
        }

        KeyEnumeration() {
            OrderedHashtable.this = OrderedHashtable.this;
        }
    }

    private class ValueEnumeration
    implements Enumeration {
        int currentIndex;

        public boolean hasMoreElements() {
            return this.currentIndex < OrderedHashtable.this.values.size();
        }

        public Object nextElement() {
            if (this.currentIndex < OrderedHashtable.this.values.size()) {
                return OrderedHashtable.this.values.elementAt(this.currentIndex++);
            }
            return null;
        }

        ValueEnumeration() {
            OrderedHashtable.this = OrderedHashtable.this;
        }
    }
}

